function [Y,UMFYy,UMFYmu,LMFYy,LMFYmu] = OLWA(X,W,n)

%
% [Y, UMFYy,UMFYmu,LMFYy,LMFYmu] = OLWA(X,W,n)
%
% To compute the ordered LWA [1,2] for IT2 FSs determined by the nine 
% parameters in Fig. 1 of Readme.doc.
%
% [1] Dongrui Wu and Jerry M. Mendel, Aggregation using the linguistic 
% weighted average and interval type-2 fuzzy sets, IEEE Trans. on Fuzzy 
% Systems, vol. 15, no. 6, pp. 1145--1161, 2007.
%
% [2] Dongrui Wu and Jerry M. Mendel, Corrections to Aggregation using 
% the linguistic weighted average and interval type-2 fuzzy sets, IEEE 
% Trans. on Fuzzy Systems, in press.
%
% Dongrui WU (dongruiw@usc.edu), 11/16/2008
%
% X and W: MFs of the subcriteria and weights. They have the same number of
% rows.
% n: number of alpha-cuts. Default is 2.
%
% Y: the OLWA approximated by 9 parameters.
% UMFYy and UMFYmu: y- and mu-coordinates of the UMF of the OLWA
% LMFYy and LMFYmu: y- and mu-coordinates of the LMF of the OLWA

if nargin==2 %% set default n
    n=2;
end

[M,N]=size(X);
c=zeros(1,M);
for i=1:M
    c(i)=centroidIT2(X(i,:));
end
[c,index]=sort(c,'descend');
[Y,UMFYy,UMFYmu,LMFYy,LMFYmu]=LWA(X(index,:),W,n);

